import { NextRequest, NextResponse } from 'next/server';
import { companyStore, initializeDefaultData } from '@/lib/data-store';

export async function GET() {
  try {
    await initializeDefaultData();
    const companies = await companyStore.getAll();
    const company = companies[0] || null; // Get first (and should be only) company record
    return NextResponse.json({ success: true, data: company });
  } catch (error) {
    return NextResponse.json({ success: false, error: 'Failed to fetch company info' }, { status: 500 });
  }
}

export async function POST(request: NextRequest) {
  try {
    const data = await request.json();
    const company = await companyStore.create(data);
    return NextResponse.json({ success: true, data: company });
  } catch (error) {
    return NextResponse.json({ success: false, error: 'Failed to create company info' }, { status: 500 });
  }
}

export async function PUT(request: NextRequest) {
  try {
    const data = await request.json();
    
    // Get existing company record
    const companies = await companyStore.getAll();
    if (companies.length === 0) {
      return NextResponse.json({ success: false, error: 'No company record found' }, { status: 404 });
    }
    
    const company = await companyStore.update(companies[0].id, data);
    return NextResponse.json({ success: true, data: company });
  } catch (error) {
    return NextResponse.json({ success: false, error: 'Failed to update company info' }, { status: 500 });
  }
}